
window.addEventListener('load', initExam, false);

function initExam()
{
	// Borrar formularios si los hay ya
	var form = document.getElementById('exam');
	if ( form ) form.parentNode.removeChild(form);

	// Crear un formulario nuevo, retorna la lista de preguntas por conveniencia
	var list = createForm();

	// Crear preguntas en el formulario
	for ( var i = 0; i < exam.length; ++i )
		createQuestion( list, exam[i], i );
}

function createForm()
{
	// Crear un formulario <form>
	var form = document.createElement('form');
	form.id = 'exam';
	form.action = 'exam.php';
	form.method = 'post';

	// Una lista ordenada para almacenar las preguntas
	var list = document.createElement('ol');
	form.appendChild(list);

	// Al final del formulario agregar botones "Calificar" y "Nuevo examen"
	createButtons(form);
	document.body.appendChild(form);

	// Por conveniencia, retornar la lista para que sea llenada de preguntas
	return list;
}

function createQuestion(list, question, questionIndex)
{
	// Cada pregunta es un <li> en la lista ordenada
	var li = document.createElement('li');

	// Poner el texto de la pregunta en un párrafo <p>
	var p = document.createElement('p');
	p.appendChild( document.createTextNode(question.text) );
	li.appendChild(p);

	// Crear un botón de radio por cada una de las opciones de respuesta de la pregunta
	for ( var i = 0; i < question.options.length; ++i )
		createOption(li, question.options[i], i, questionIndex);

	list.appendChild(li);
}

function createOption(li, optionText, optionIndex, questionIndex)
{
	// Una opción es un botón de radio asociado con un label, por ejemplo:
	// <label><input type="radio" name="question1" value="1"/>Opción de respuesta 1</label><br/>

	var label = document.createElement('label');
	var input = document.createElement('input');
	input.type = 'radio';
	input.name = 'question' + questionIndex;
	input.value = optionIndex;
	input.onclick = answerQuestion;
	label.appendChild(input);
	label.appendChild( document.createTextNode(optionText) );
	li.appendChild(label);
	li.appendChild( document.createElement('br') );
}

function createButtons(form)
{
	// Crear una <section id="grade_section"> donde se escribirá la calificación cuando
	// se presione el botón Calificar
	var gradeSection = document.createElement('section');
	gradeSection.id = 'grade_section';
	form.appendChild(gradeSection);

	// Insertar los botones en una <section id="exam_buttons">
	var section = document.createElement('section');
	section.id = 'exam_buttons';

	// Crear el botón "Calificar", agregarlo a la sección
	// deshabilitarlo hasta que se hayan respondido todas las preguntas
	var button = createButton(section, 'grade_exam_button', 'Calificar', gradeExam, 'button');
	disableButton(button);

	// Crear el botón "Nuevo examen" y agregarlo a la sección
	createButton(section, 'new_exam_button', 'Nuevo examen', newExam, 'submit');

	form.appendChild(section);
}

// Crear un botón <button id="id">label</button> hijo de parent
// el cual invoca a la función func cuando se emite su evento onclick
function createButton(parent, id, label, func, type)
{
	var button = document.createElement('button');
	button.id = id;
	button.onclick = func;
	button.appendChild(document.createTextNode(label));
	parent.appendChild(button);
	button.type = type;

	return button;
}

// Se invoca cuando el usuario presiona el botón "Calificar", lo cual ocurre solo una
// única vez por examen
function gradeExam()
{
	// Calcular la nota obtenida y pintar las opciones correctas e incorrectas
	var grade = calculateGrade();

	// Imprimir la calificación en la sección creada para ello del documento
	var gradeSection = document.getElementById('grade_section');
	gradeSection.appendChild( document.createTextNode('Calificación: ' + grade) );

	// Si la nota es aprobatoria o no, indicarlo con estilos
	gradeSection.className = grade >= 70 ? 'right_answer' : 'wrong_answer';

	// Una vez calificado un examen, no se permite al estudiante modificar las respuestas
	// y volver a calificar, puesto que se le han mostrado las respuestas
	disableButton('grade_exam_button');
	return false;
}

// Se invoca cuando el usuario presiona el botón "Nuevo examen"
function newExam()
{
	return window.confirm('¿Realmente desea crear un nuevo examen?');
}

// Retorna la nota obtenida por el estudiante
function calculateGrade()
{
	// Se suman los puntos obtenidos en cada pregunta contestada correctamente
	var grade = 0;
	for ( var i = 0; i < exam.length; ++i )
		grade += calculateQuestionGrade(exam[i], i);
	return grade;
}

function calculateQuestionGrade(question, questionIndex)
{
	// Si la respuesta marcada por el usuario corresponde con la respuesta en el objeto exam
	// el estudiante obtuvo los puntos (el peso) de la pregunta, de lo contrario cero
	var userAnswer = getUserAnswer(question, questionIndex, question.answer, true);
	return userAnswer == question.answer ? question.weight : 0;
}

// Retorna el índice de la opción de respuesta marcada por el estudiante, o undefined si
// no se ha respondido la pregunta. Si se envia true en stylizeAnswers se resaltarán las
// opciones de respuesta correctas o incorrectas con colores
function getUserAnswer(question, questionIndex, answer, stylizeAnswers)
{
	var result = undefined;

	// Obtener todos los botones de radio de la pregunta para saber cual está marcado
	var inputs = document.getElementsByName('question' + questionIndex);
	for ( var i = 0; i < inputs.length; ++i )
	{
		// Si se encontró el botón de radio marcado, su índice será la respuesta
		if ( inputs[i].checked )
			result = i + 1;

		// Si se pidió darle color a las opciones y esta es la correcta, marcarla en verde
		if ( stylizeAnswers && i + 1 == answer )
			inputs[i].parentNode.className = 'right_answer';

		// Si se pidió darle color a las opciones, esta es la marcada pero no la correcta
		// marcarla en rojo
		if ( stylizeAnswers && i + 1 != answer && inputs[i].checked )
			inputs[i].parentNode.className = 'wrong_answer';
	}

	return result;
}

// Se invoca cada vez que una opción de respuesta es marcada
function answerQuestion()
{
	// Si todas las preguntas están contestadas, habilitar el botón "Calificar"
	if ( areAllQuestionsAnswered() )
		enableButton('grade_exam_button');
}

function areAllQuestionsAnswered()
{
	// Recorrer las preguntas, si alguna no ha sido contestada, retornar false
	for ( var i = 0; i < exam.length; ++i )
		if ( getUserAnswer(exam[i], i, exam[i].answer, false) == undefined )
			return false;

	// Si se llegó aquí, todas las preguntas están contestadas
	return true;
}

function disableButton(button)
{
	// Habilitar un botón significa darle el atributo disabled='disabled'
	if ( typeof button == 'string' ) button = document.getElementById(button);
	if (button) button.disabled = 'disabled';
}

function enableButton(button)
{
	// Habilitar un botón significa quitar su atributo disabled='disabled'
	if ( typeof button == 'string' ) button = document.getElementById(button);
	if (button) button.removeAttribute('disabled');
}
