<!DOCTYPE html>
<html lang="es" xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta charset="utf-8"/>
	<title>Examen autogenerado</title>
	<link type="text/css" href="exam.css" rel="stylesheet" />
</head>
<body>
	<h1>Examen autogenerado</h1>
	<noscript>Esta página necesita JavaScript para funcionar apropiadamente.</noscript>
	<script><?php
		// Represents a Question fetched from the database
		class Question
		{
			// The unique question number
			public $id;
			// Question text: the text read by the visitor
			public $text;
			// A bigger value in this field indicates a more difficult question.
			// When an user answers this question correctly, he/she will accumulate this weight.
			public $weight;
			// Each suitable answer for the question, one per line
			public $options;
			// The index of option that correctly answers the question
			public $answer;

			// Adjust some values after fetching from database
			public function adjust_values()
			{
				// All options are stored into a single string separated by line feeds
				// But we require them into an array of strings in order to produce the JSON object
				$this->options = explode("\n", $this->options);

				// Convert to integer the other values
				$this->id = (int) $this->id;
				$this->weight = (int) $this->weight;
				$this->answer = (int) $this->answer;
			}

			public function print_json()
			{
				echo "\n{\n\tid: ", $this->id,
					",\n\ttext: '", $this->text,
					"',\n\tweight: ", $this->weight,
					",\n\toptions:\n\t[";

				for( $i = 0; $i < count($this->options); ++$i )
					echo "\n\t\t'", $this->options[$i], "',";

				echo "\n\t],\n\tanswer: ", $this->answer, "\n}";
			}
		}

		// A controller class to generate an exam with random questions in JSON notation
		class Exam
		{
			// Connection to the database
			protected $pdo;
			// The total number of questions available in the database
			protected $totalQuestions;
			// The requested number of random questions
			protected $size;
			// An array with $size random questions
			protected $questions;

			public function __construct($size)
			{
				// Connect to the database
				$this->pdo = new PDO("mysql:host=localhost;dbname=exam", 'exam', 'P0987ytr43wq1');

				// Get the total number of questions
				$this->totalQuestions = $this->fetch_total_questions();

				// Get the number of asked questions by parameter
				$this->size = $this->validate_size($size);

				// Fill the $questions array with random questions fetched from database
				$this->questions = array();
				$this->fetch_random_questions();
			}

			public function fetch_total_questions()
			{
				// Get the number of questions in database
				$statement = $this->pdo->prepare('SELECT max(id) from question');
				$statement->execute();

				// If a number was returned from the database, use it, instead 0 for error
				if ( $row = $statement->fetch() ) return (int) $row[0]; else return 0;
			}

			public function validate_size($size)
			{
				// If the requested number of questions is valid, use it
				if ( $size >= 1 && $size <= $this->totalQuestions )
					return $size;

				// The $size is not valid, use 10 as default if it is also valid
				return min(10, $this->totalQuestions);
			}

			protected function fetch_random_questions()
			{
				// Generate an array of $size random ids
				$ids = $this->generate_random_ids();

				// Get the questions in the ids positions from the database
				$statement = $this->pdo->prepare('
					SELECT *
					FROM question
					WHERE id IN (' . implode($ids, ', ') . ')');

				// Represent each resulting row as an object
				$statement->setFetchMode(PDO::FETCH_CLASS, 'Question');

				// Run the query against the database
				$statement->execute();

				// Store each question in the $questions internal array
				while ( $question = $statement->fetch() )
				{
					// Convert options and other adjustments
					$question->adjust_values();

					// Add the new question to the internal array
					array_push($this->questions, $question);
				}
			}

			protected function generate_random_ids()
			{
				$result = array();
				srand( time() );

				// Remark: this algorithm is ineficient when $size == $totalQuestions
				for ( $i = 0; $i < $this->size; ++$i )
				{
					// Generate a random question id, but it must be unique in $result array
					do
					{
						$random_id = rand(1, $this->totalQuestions);
					} while ( in_array($random_id, $result) );

					// Add the id random id to the array
					$result[] = $random_id;
				}

				return $result;
			}

			public function print_json()
			{
				if ( defined(PHP_VERSION_ID) && PHP_VERSION_ID > 50400 )
				{
					echo "var exam = ";
					echo json_encode( $this->questions, JSON_UNESCAPED_UNICODE );
					echo ";";
				}
				else
				{
					echo "var exam = [";
					for ( $i = 0; $i < count($this->questions); ++$i )
						echo $this->questions[$i]->print_json(), ",";
					echo "\n];";
				}
			}
		}

		try
		{
			// The number of random questions can be sent by parameter
			$size = isset($_GET['size']) ? (int) $_GET['size'] : 10;

			// Create an Exam object with $size random questions
			$exam = new Exam($size);

			// Print the exam as an JSON object
			$exam->print_json();
		}
		catch (PDOException $e)
		{
			echo '<tr><td class="error">Database error: ' . $e->getMessage() . '</td></tr>';
		}
	?></script>
	<script src="exam.js"/>
</body>
</html>
