<?php
session_start();

// Login must be done under HTTPS only
if ( $_SERVER['SERVER_PORT'] != 443 )
{
	header('Location: https://cursoweb.ecci.ucr.ac.cr/material/cap08/chat/');
	exit(0);
}

// Save the referrer script in order to redirect browser when user has logged in
if ( isset($referrer_after_login) && $referrer_after_login != '' )
	$_SESSION['login_referrer'] = $referrer_after_login;

// Determine if this script was called after submiting the form
require_once('../../php/sanitize.php');
$username = isset($_POST['username']) ? sanitize_trim($_POST['username']) : '';

if ( $username != '' )
{
	$_SESSION['username'] = $username;
	$location = isset($_SESSION['login_referrer']) ? $_SESSION['login_referrer'] : './';
	header('Location: ' . $location);
	unset($_SESSION['login_referrer']);
	exit(0);
}

// Check if visitor is already logged in
if ( isset($_SESSION['username']) )
{
	// Visitor is appropiately logged in, do nothing here. Continue with the caller logic
}
else
{
	// No visitor is logged in this execution of the script, ask for credentials
	echo <<<_EOT
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta charset="utf-8"/>
	<title>Login</title>
	<link type="text/css" href="chat.css" rel="stylesheet" />
</head>
<body>
	<form method="post" action="simple_login.php" class="login_form">
		<p>Escriba un nombre de usuario para chatear:</p>
		<p><label>Usuario <input type="text" name="username" id="username"/></label>
		<button type="submit"><img src="../../img/accept.png" alt=""/> Ingresar</button></p>
	</form>
</body>
</html>
_EOT;
	// Do not continue with the logic of the caller script
	exit(0);
}
?>
