<?php
	$referrer_after_login = './';
	include_once('simple_login.php');
?>
<!DOCTYPE html>
<html lang="es" xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta charset="utf-8"/>
	<meta name="author" content="Jeisson Hidalgo-Céspedes"/>
	<title>Chat masivo</title>
	<link type="text/css" href="chat.css" rel="stylesheet" />
	<script src="chat.js"/>
</head>
<body>
	<table id="chat_board"><tbody><?php
		// This include only works in cursoweb.ecci.ucr.ac.cr
		include_once('../../php/sanitize.php');
		include_once('/home/jhc/etc/php/db_credentials.php');

		// Each message is stored in the 'chat' table of a MySQL database
		// This class is used to represent an interchangeable message between web and database
		class Message
		{
			// The primary key: a sequential integer
			protected $idmessage;
			// When the message was issued
			protected $datetime;
			// The nickname of the user that issued the message, limited to 32 characters
			protected $username;
			// The message text. Only a few (X)HTML tags are allowed: a, b, i, u.
			protected $message;

			// Returns an (X)HTML paragraph representing this message
			function formatMessage()
			{
				return '<tr><td class="author"><span class="username">'
					. $this->username . '</span><br/><span class="datetime">'
					. $this->datetime . '</span></td><td class="message">'
					. $this->message . '</td><td class="idmessage">'
					. $this->idmessage . '</td></tr>';
			}
		}

		try
		{
			// Connect to the database
			$pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);

			// If a message was sent by visitor, store it into the database before retrieving
			// the existing messages
			$new_message = isset($_REQUEST['new_message'])
				? sanitize_trim($_REQUEST['new_message']) : '';
			if ( $new_message != '' )
			{
				$statement = $pdo->prepare('
					INSERT INTO chat (datetime, username, message)
					VALUES (NOW(), :username, :message);');

				// Run the query against the database. Sanitizing is made by $statement
				$statement->execute( array
					( ':username' => $_SESSION['username']
					, ':message' => $new_message ) );
			}

			// The minimum and maximun number of messages to display can be sent by parameter
			$from_message = isset($_REQUEST['frommessage']) ? $_REQUEST['frommessage'] : 0;

			// Get the latest messages from database
			$statement = $pdo->prepare('
				SELECT idmessage, datetime, username, message
				FROM chat
				WHERE idmessage >= :from_message
				ORDER BY idmessage');

			// Represent each resulting row as an object
			$statement->setFetchMode(PDO::FETCH_CLASS, 'Message');

			// Run the query against the database. Sanitizing is made by $statement
			$statement->execute( array( ':from_message' => $from_message) );

			// Print each message as an paragraph into the board section of the result document
			while ( $message = $statement->fetch() )
				echo "\t\t", $message->formatMessage(), "\n";
		}
		catch (PDOException $e)
		{
			echo '<tr><td class="error">Database error: ' . $e->getMessage() . '</td></tr>';
		}
	?></tbody></table>
	<form method="post" action="./" id="send_message_form">
		<input type="text" name="new_message" id="message_field"/>
		<button type="submit" id="send_button"><img src="../../img/post.png" alt=""/>Actualizar</button>
	</form>
</body>
</html>
