window.addEventListener('load', initChat, false);

function initChat()
{
	// Focus the message field after loading the document
	focusMessageField();

	// Interven the form to avoid whole page refresh
	var form = document.getElementById('send_message_form');
	if ( form ) form.onsubmit = formSubmitAjax;

	// Update the board periodically
	window.setInterval(updateBoard, 2000);
}

function focusMessageField()
{
	var field = document.getElementById('message_field');
	if ( field )
	{
		field.focus();
		field.onkeyup = updateSendButton;
	}
}

function updateSendButton()
{
	var field = this;
	var button = document.getElementById('send_button');
	if ( field && button )
	{
		var text = field.value.replace(/^\s+|\s+$/, '');
		var buttonLabel = button.childNodes[1];
		if ( buttonLabel && buttonLabel.nodeType == Node.TEXT_NODE )
			buttonLabel.nodeValue = text.length > 0 ? 'Enviar' : 'Actualizar';
	}
}

function updateBoard()
{
	var request = new XMLHttpRequest();

	// Get the id of the lastest loaded message in the document
	var frommessage = findLastIdMessage() + 1;

	// Ask for new messages in the database
	request.open('get', 'chat_ajax.php?frommessage=' + parseInt(frommessage));

	// When new messages are sent by web server, this method will be called
	request.onreadystatechange = function() { handleResponse(request); }

	// Send the request
	request.send(null);
}

function handleResponse(request)
{
	// If the request is complete, status is 4
	if ( request.readyState == 4 )
	{
		// If the request is complete and successfull
		if ( request.status == 200 || request.status == 304 )
		{
			// The server outputs XHTML code
			var newrows = request.responseText;
			if (newrows.length > 0)
			{
				// Insert them as children of the <tbody> of the table with the board of the chat
				var table = document.getElementById('chat_board');
				table.firstElementChild.innerHTML += newrows;

				// Make the text field visible again
				focusMessageField();
			}
		}
		else
		{
			// The request is complete but there was an error, proceed as usual
			document.getElementById('send_message_form').submit();
		}
	}
}

function findLastIdMessage()
{
	var table = document.getElementById('chat_board');
	var lastrow = table.rows[ table.rows.length - 1 ];
	var idcell = lastrow.getElementsByClassName('idmessage')[0];
	return parseInt(idcell.textContent);
}

function formSubmitAjax()
{
	var request = new XMLHttpRequest();

	// Get the id of the lastest loaded message in the document
	var frommessage = findLastIdMessage() + 1;

	// Call the PHP script. Use the POST method. Open the connection:
	request.open('post', 'chat_ajax.php?frommessage=' + parseInt(frommessage));

	// Function that handles the response:
	request.onreadystatechange = function() { handleResponse(request); }

	// Assemble the query string
	var field = document.getElementById('message_field');
	queryString = 'new_message=' + encodeURIComponent(field.value);

	// Set the request headers:
	request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

	// Send the request along with the data:
	request.send(queryString);

	// Avoid form being submitted
	return false;
}
