#include "Game.h"
#include "Obstacle.h"
#include "Player.h"
#include "Score.h"

#include <QGraphicsView>
#include <QGraphicsScene>
#include <QSvgRenderer>
//#include <QMediaPlayer>
//#include <QSoundEffect>
#include <QTime>
#include <QTimer>

Game::Game(int &argc, char **argv, int flags)
	: QApplication(argc, argv, flags)
	, scene(nullptr)
	, view(nullptr)
	, score(nullptr)
{
}

Game::~Game()
{
	delete scene;
	delete view;
}

int Game::run()
{
	// Init the random seed
	qsrand(QTime::currentTime().msec());

	// An invisible object that manages all the items
	scene = new QGraphicsScene();

	// Any visible item to place in the scene
	view = new QGraphicsView(scene);
  #if ! defined(Q_OS_ANDROID) && ! defined(Q_OS_IOS)
	view->resize(800, 600);
  #endif

	// Set a black background and add a nebula over it
	view->setBackgroundBrush(QBrush(Qt::black, Qt::SolidPattern));
//	scene->addItem( new QGraphicsPixmapItem(QPixmap(":/Resources/Background.png")) );

	// The scene has infinite size, but we want it has the same size than the view
	// This stops the weird behavior of the autoscroll feature of the view being smaller than the
	// scene, because the scene auto-increases to include the bullets being moved
	scene->setSceneRect( view->rect() );

	// Disable scrollbars because they are not needed
	view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

	// A label to show the player score
	score = new Score(tr("Score"), 0, Qt::blue);
	score->setPos(0, 0);
	scene->addItem(score);

	// Load the graphic resources
	svgRenderer = new QSvgRenderer(QString("://Resources/assets.svg"), this);

	// Create the player control
	Player* player = new Player();
	player->setSharedRenderer(svgRenderer);
	scene->addItem(player);
	player->setInitialPos();

	// Launch an enemy periodically
	QTimer* timer = new QTimer(this);
	connect(timer, &QTimer::timeout, this, &Game::launchObstacle);
	timer->start(2500);

	// Play background music
//	playBackgroundMusic("BackgroundMusic.mp3");

	// Show the view and enter in application's event loop
	view->show();
	return exec();
}

void Game::playBackgroundMusic(const QString& audioFilename)
{
/*	QMediaPlayer* mediaPlayer = new QMediaPlayer(this);
  #ifdef Q_OS_OSX
	mediaPlayer->setMedia(QUrl::fromLocalFile(Game::applicationDirPath() + "/Resources/" + audioFilename));
  #else
	mediaPlayer->setMedia(QUrl("qrc:/Resources/" + audioFilename));
  #endif
	mediaPlayer->play();
*/
}

void Game::launchObstacle()
{
	Obstacle* obstacle = new Obstacle();
	obstacle->setSharedRenderer(svgRenderer);
	scene->addItem(obstacle);
	obstacle->setInitialPos();
}
