#include "Player.h"
#include <QKeyEvent>
#include <QGraphicsScene>
#include <QGraphicsSceneMouseEvent>
#include <QPropertyAnimation>
#include <QTimer>
//#include <QSoundEffect>
#include <QtMath>

Player::Player()
{
	// Set graphic image
	setElementId( QString("monster%1").arg( qrand() % 3 ) );
//	setFlags(QGraphicsItem::ItemIsSelectable|QGraphicsItem::ItemIsMovable);

/*
	// To play sounds
	soundEffect = new QSoundEffect(qApp);
	soundEffect->setSource(QUrl("qrc:/Resources/Sound.wav"));
	soundEffect->setVolume(0.98f);
*/
	connect(timer, &QTimer::timeout, this, &Player::move);
	timer->setInterval(1000);
	timer->start();

	QTimer* collisionTimer = new QTimer(this);
	connect(collisionTimer, &QTimer::timeout, this, &Player::detectCollisions);
	collisionTimer->setInterval(25);
	collisionTimer->start();
}

Player::~Player()
{
}

void Player::setInitialPos()
{
	// Place the player in the middle bottom of the scene
	qreal x = (scene()->width() - boundingRect().width()) * 0.5;
	qreal y = (scene()->height() - boundingRect().height()) * 0.5;
	setPos(x, y);
}

void Player::keyPressEvent(QKeyEvent* event)
{
/*	// Move this object if arrow keys are pressed
	if ( event->key() == Qt::Key_Left && x() )
		moveLeft();
	else if ( event->key() == Qt::Key_Right )
		moveRight();
	else if ( event->key() == Qt::Key_Up )
		setPos( x(), y() - 10.0 );
	else if ( event->key() == Qt::Key_Down )
		setPos( x(), y() + 10.0 );
	// Do something if the spacebar is pressed
	else if ( event->key() == Qt::Key_Space )
		doSomething();
*/
}

#include <iostream>
void Player::mousePressEvent(QGraphicsSceneMouseEvent* event)
{
	std::cerr << "(" << event->pos().x() << ", " << event->pos().y() << ")\n";
}

void Player::move()
{
//	setPos( pos().x() + qrand() % 10 - 5, pos().y() + qrand() % 10 - 5 );
//	detectCollisions();

	QPropertyAnimation* animation = new QPropertyAnimation(this, "pos");
	animation->setDuration(1000);
	animation->setStartValue(QPointF(pos().x(), pos().y()));
	QPointF endPos(qrand() % int(scene()->width()), qrand() % int(scene()->height()));
	animation->setEndValue(endPos);

	animation->start();
}

#include "Obstacle.h"
void Player::detectCollisions()
{
	const QList<QGraphicsItem*>& items = collidingItems();
	for ( QGraphicsItem* item : items )
	{
		if ( Obstacle* obstacle = dynamic_cast<Obstacle*>(item) )
		{
			//obstacle->setOpacity(0.0);
			scene()->removeItem(obstacle);
		}
	}
}
