#ifndef PLAYER_H
#define PLAYER_H

#include "AnimatedObject.h"

class QSoundEffect;

/**
	@brief A simple rectangle able to react to arrow keys when they are pressed
 */
class Player : public AnimatedObject
{
	Q_OBJECT
	Q_PROPERTY(QPointF pos READ pos WRITE setPos)

  protected:
	/// To generate sounds when the bullet is fired
//	QSoundEffect* soundEffect;

  public:
	/// Constructor
	Player();
	/// Destructor
	~Player();
	/// Centers the player in the center bottom of the scene
	void setInitialPos();
	/// Called if this object has the focus and a key is pressed by user
	virtual void keyPressEvent(QKeyEvent* event) override;
	/// For testing, when it is clicked, it will fire a bullet
	virtual void mousePressEvent(QGraphicsSceneMouseEvent *event) override;

  protected slots:
	void move();
	void detectCollisions();
};

#endif // PLAYER_H
