#ifndef SCORE_H
#define SCORE_H

#include <QGraphicsTextItem>

class Score : public QGraphicsTextItem
{
	Q_OBJECT

  protected:
	/// This scores measures something: health, power, bonus, points...
	QString legend;
	/// The amount scored
	int score;

  public:
	Score(const QString& legend, int initialScore, QColor color, QGraphicsItem *parent = nullptr);
	~Score();
	inline int getScore() const { return score; }
	void increase(int amount = 1);
	void decrease(int amount = 1);

  protected:
	void updateScore();
};

#endif // SCORE_H
